<?php
/**
 * FormIt
 *
 * Copyright 2009-2012 by Shaun McCormick <shaun@modx.com>
 *
 * FormIt is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * FormIt is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * FormIt; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA
 *
 * @package formit
 */

require_once dirname(dirname(__DIR__)) . '/src/FormIt/Hook.php';

/**
 * Base Hooks handling class. Hooks can be used to run scripts prior to loading the form, or after a form has been
 * submitted.
 *
 * Hooks can be either a predefined list by FormIt, or custom MODX Snippets. They can also be chained to allow for
 * order-of-execution processing. Returning false from a Hook will end the chain. Returning false in a postHook will
 * prevent the form from being further submitted.
 *
 * @package formit
 */
class fiHooks extends Sterc\FormIt\Hook {}
