<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => 'GNU GENERAL PUBLIC LICENSE
   Version 2, June 1991
--------------------------

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

Preamble
--------

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation\'s software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author\'s protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors\' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone\'s free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.


GNU GENERAL PUBLIC LICENSE
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
---------------------------------------------------------------

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program\'s
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients\' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

NO WARRANTY
-----------

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

---------------------------
END OF TERMS AND CONDITIONS',
    'readme' => '--------------------
Snippet: FormIt
--------------------
Author: Sterc <modx@sterc.nl>

A form processing Snippet for MODx Revolution.

Official Documentation:
https://docs.modx.com/extras/revo/formit',
    'changelog' => 'Changelog for FormIt.

FormIt 4.2.5
====================================
- Added new properties to email hook (#229, thanks to @jako)
      - emailSelectTo, emailSelectToName, emailSelectField

FormIt 4.2.4
====================================
- Fix export form select width (#218)
- Fix limit of form filter (#206)
- Fix path to clean processor for cronjob (#215, thanks to @bennyb)
- Fix ability to export all forms (#210, thanks to @JoshuaLuckers)
- Fix PHP notice \'Only variables should be assigned by reference\' in Hook.php (#212, thanks to @intersel)
- Updated Russian translation (#208, thanks to @webinmd)

FormIt 4.2.3
====================================
- FormIt 4.2.0 release bug - Fix migration of forms with encryption

FormIt 4.2.2
====================================
- FormIt 4.2.0 release bug - Altering tables on update (#203)

FormIt 4.2.1
====================================
- FormIt 4.2.0 release bug (#202)

FormIt 4.2.0
====================================
- Bug on hasHook() fixed (#182, #181, #170, #193)
- ExtJS refactored for faster and better UI/UX
    - IP number added to the grid (#194)
    - Better form view with textfields and textareas (#136)
    - Remove multiple forms (#143)
    - Search by IP (and context menu option to view all forms from 1 IP)
- New permissions added
    - formit_encryptions to encrypt/decrypt forms
    - Context awereness, an user can only see the forms with the contexts that the user has access to.
- Swedish translation updated
    - All other language files checked and filled with English strings
- Formit deprecation notice in 2.7.0dev bug fixed (#190)

FormIt 4.1.2
====================================
- Fix spam hook for better spam prevention thanks to Kristoffer Karlström
- Fix FormItLoadSavedForm for encrypted forms

FormIt 4.1.1
====================================
- Added new hook "renderHooks", which triggers just before rendering the form

FormIt 4.1.0
====================================
- This release is made possible thanks to Bert Kooij / Census.nl. Thanks!
- Added new button in Manager page for manually removing forms.
- Added new system setting for the default amount of days.
- Added cronjob task for automatically deletion of old forms.

FormIt 4.0.1
====================================
- Add option to specify csv delimiter for form export
- Add GDPR compliant attachment handling (#154) - Thanks to @wax100
- Allow empty isDate validator (PR#164) - Thanks to JoshuaLuckers
- Fix bug with multiple forms on one page (#160)
- Fix modx->log calls in various classes (#161)
- Fix setting redirectParams variable (#165)

FormIt 4.0.0
====================================
- Move formit base classes to /src/ folder and add namespace
- Update existing classes to extend new classes
- Update all snippets to use modx getService
- Move FormItAutoResponder and FormItSaveForm logic to classes
- Add helper functions for all FormIt properties
- Set defaultEngine to InnoDB in mysql schema
- Fix PHP7 error in default email output (PR#156)
- Updated German lexicons (PR#150)
- Add \'Form\' column to form export (PR#149)

FormIt 3.0.4
====================================
- Fix checkbox values not showing in email

FormIt 3.0.3
====================================
- Fix FormItSaveForm to allow multiple fields with same fieldName
- Add \'saveTmpFiles\' FormIt snippet property to enable/disable saving files to tmp directory
- Remove list() function from formitsaveform snippet for better PHP version compatibility (#98)
- Fix PHP7 by-reference errors (#98)
- Replace ereg() functions with preg_match() for PHP compatibility (#98)
- Increase precision for FormItForm \'ip\' field to allow for IPV6 addresses (#135)
- Fix issue where in some cases fields are not correctly saved in FormItForm (#92)
- Optimize FormItForm export class for better performance (#120)
- Add \'attachFilesToEmail\' property to control if files are added as attachment to email (#122)

FormIt 3.0.2
====================================
- Fix encryption in formitsaveform snippet to save correct encryption_type
- Fix bug in forms grid when decrypting encrypted forms fail
- Fix migration to check if decrypted data is correct

FormIt 3.0.1
====================================
- Store file uploads in tmp folder to prevent file uploads getting lost in multistep forms
- Add checks for OpenSSL in classes and encryption CMP tab
- Add method_exists check to plugin to prevent errors when method not exists
- Update context-menu in forms-encryption grid to show only encrypt or decrypt
- Set placeholders for file upload $_FILES array
- Add option to FormItCountryOptions snippet to limit country list to selected countries only (PR#123) - thanks to gadgetto

FormIt 3.0.0
====================================
- PLEASE NOTE: THIS UPDATE CONTAINS A MIGRATION SCRIPT FOR ENCRYPTED FORMS - Read more about it at https://github.com/Sterc/FormIt
- Mcrypt encryption/decryption methods replaced with openssl due to mcrypt being deprecated in PHP 7.1
- Add default file-based chunks as objects
- Add support for pdoTools getChunk method, thanks to soulcreate and bezumkin (PR#89)
- Add French countries for FormItCountryOptions, thanks to beau-gosse (PR#109)
- Add Dutch countries for FormItCountryOptions, thanks to visvoer (PR#110)
- Add extjs stateful parameters to CMP tabs

FormIt 2.2.11
====================================
- Added storeLocation property to FormIt and FormItRetriever. (issue #95, PR #105#106#107)
- Changed default behaviour of emailReplyTo parameter to fallback to email field in form (issue #101)
- Changed math hook to store values in session, preventing easy bypass of math hook (issue #64)
- Add GPM config
- Fix bug with multiple file upload (PR #104)
- Add \'hash\' field to FormItSaveForm to allow updating of previously saved forms (PR #94)
- Add FormItLoadSavedForm snippet to retrieve saved forms (PR #94)
- Fix for export with datefilter (issue #96, PR #97)
- Add fiarRequired property (PR#83)
- Update resolver to check for current version to prevent errors on upgrade
- Add system setting for form_encryptkey, to not rely on site_id (issue #68)
- Fix saved forms export when using encrypted forms (issue #48)

FormIt 2.2.10
====================================
- Merged PR#58: Added BOM for Excel to understand UTF-8 non-latin symbols properly. (thanks to govza)
- Merged PR#73: JSON output options for errors and hooks
- Merged PR#79: Create German lexicon for FormIt-CMP (thanks to sebastian-marinescu)

FormIt 2.2.9
====================================
- Merging PR#74 from Jako which solves multiple issues.
- Fix XSS vulnerabilities
- Javascript code cleanup
- Fix empty math operator after form submission #d782c29

FormIt 2.2.8
====================================
- Fixed export limit and added form dropdown paging #60
- Fixed typo property lexicons #57
- Added templates path to config #63
- Added loading lexicons in ficountryoptions class #21
- Added ability to dynamically set formName by setting placeholder inside formName equal to an existing form field key #45

FormIt 2.2.7
====================================
- Optimised export

FormIt 2.2.6
====================================
- Fixed empty placeholder for file field in autoresponder

FormIt 2.2.5
====================================
- Fixed creating table on update
- Added new tab inside CMP for managing encryption
- Added missing br on auto emailTpl

FormIt 2.2.4
====================================
- Fixed bug inside FormItSaveForm and PR #43

FormIt 2.2.3
====================================
- Added encryption to saved forms
- Added formname to grid
- Saved form is now returned from the hook
- Export unlimited items
- Add RU translation

FormIt 2.2.2
====================================
- Added CMP for the saved forms
- Fixed whitespace PR on required checkboxes

FormIt 2.2.1
====================================
- Updated numbers generation for math captcha #5
- German translation #10
- Added missing formit.not_regexp lexicon #15
- Specify explicitely return-path fixes #19 #20
- fix addAttachment() typo #23
- Fixed typo in adding of the attachments #24
- Add the possibility of redirectTo=`formfield` #26
- Added attachments for auto-reply and Added ability to use @CODE as tpl #29
- Update snippet.formitisselected.php #12
- Canadian options for FormitStateOptions

FormIt 2.2.0
====================================
- [#8382] Prevent issue with checkboxes/radios causing text-parsing problems with required validator
- Fixed issue with custom error message for vTextPasswordConfirm not respected
- [#9457] Fixed issue with commas in values causing errors with FormItIsChecked & FormItIsSelected
- [#9576] Add ability to translate country options
- Add check for preHook errors before processing postHooks
- Add option, defaulting true, to trim spaces from sides of values before validation
- [#8785] Fix E_STRICT error in fiDictionary

FormIt 2.1.2
====================================
- Various language updates
- [#7250] Fix issue with 0 not passing :required filter

FormIt 2.1.1
====================================
- [#8204] Fix issue with FormItAutoResponder and processing of MODX tags

FormIt 2.1.0
====================================
- [#7620] Allow for MODX tags in email templates, as well as pass-through of snippet properties to tpl
- [#7502] Add ability to find type of hook by using $hook->type
- [#8151] More sanity checking for FormItAutoResponder and replyTo addresses
- Fix useIsoCode issue in FormItCountryOptions
- Update German translation
- Enhance validation templating for validationErrorBulkTpl
- Add &country option to FormItStateOptions to allow loading of non-US states (currently us/de)

FormIt 2.0.3
====================================
- Update Czech translation
- Fix issue with French accents in translation
- [#6021] Refactor Russian reCaptcha translations
- [#6618] Standardize XHTML in reCaptcha usage

FormIt 2.0.2
====================================
- [#4864] Fix issue with isNumber not allowing blank fields
- [#5404] Fix issues with checkboxes and array fields in FormItAutoResponder
- [#5269] Fix issues with checkboxes in various forms in emails
- [#5792] Update reCaptcha URLs

FormIt 2.0.1
====================================
- [#5525] Add &allowFiles property, that when set to 0, prevents file submissions on form
- [#5484] Fix issue with double validation error spans
- Fix issue where config was not passed to hooks
- Update German translation

FormIt 2.0.0
====================================
- [#3514] Add ability to customize validator error messages per FormIt form and per field
- [#4705] Add regexp validator
- [#5454] Fix issue with customValidators property in 2.0.0-rc2
- Major reworking of main FormIt script to be OOP
- Add over 150 unit tests to prevent regression
- [#5388], [#5240] Fix issue with FormItCountryOptions and &useIsoCode
- Fix issue with FormItStateOptions and &useAbbr
- [#5267] Fix issue with FormItRetriever and array fields

FormIt 1.7.0
====================================
- Add ability to have "Frequent Visitors" optgroup in FormItCountryOptions, moving specified countries to the top of the list in an optgroup
- Add missing property translations for FormItStateOptions snippet
- Fix small issue with stored values after validation of fields
- Add FormItStateOptions snippet for easy U.S. state dropdowns
- Add FormItCountryOptions snippet for easy country dropdowns
- [#5101] Fix issue with emailMultiSeparator and emailMultiWrapper default values
- Fix issue with bracketed field names being added as extra fields post-validation with . prefix

FormIt 1.6.0
====================================
- [#4708] Add support for bracketed fields, such as contact[name]
- [#5038] Fix uninitialized variable warnings in reCaptcha service
- [#4993] Add Italian translation and fix recaptcha links
- Fix issue where fields could be removed via DOM from form and be bypassed
- Add &emailMultiSeparator and &emailMultiWrapper for handling display of checkboxes/multi-selects in email hook

FormIt 1.5.6
====================================
- [#4564] Fix redirectTo with non-web contexts

FormIt 1.5.5
====================================
- [#4168] Add emailConvertNewlines property for handling newlines in HTML emails
- [#4057] Prevent math hook from generating similar numbers
- [#4302] Cleanups to FormItAutoResponder snippet
- [#3991] Fix issue with checkbox values in emails

FormIt 1.5.4
====================================
- Fix issue with math hook where error placeholders were incorrect
- Fix issue where emailHtml property was not respected in email hook
- Fix issue where hooks were not passed customProperties array
- [#51] Allow blank fields to be passed with :email validator
- [#55] Allow all fields to be accessed in custom validators

FormIt 1.5.3
====================================
- [#40] Add ability to display all error messages in bulk at top, added validationErrorBulkTpl for templating each one
- [#52] Add a general validation error message property, validationErrorMessage, that shows when validation fails
- [#53] Fix bug that prevented recaptcha options from working
- Add a generic validation error placeholder in FormIt to allow for general messages
- [#50] Trim each hook specification in hooks calls
- [#49] Ensure reCaptcha service instance is unique for each FormIt instance
- [#47] Ensure email validator checks for empty string
- [#42] Can now include field names in error strings via `field` placeholder
- [#39] Fix issue with FormItIsChecked/Selected to prevent output from occurring if not checked
- [#37] Fix allowTags validator to work, and work with parameters encapsulated by ^

FormIt 1.5.2
====================================
- Fixed security vulnerability
- Added math hook, allowing anti-spam math field measure
- Added more debugging info to email hook

FormIt 1.5.1
====================================
- Fixed issue where &store was not respecting values set in post-hooks
- Redirect hook now redirects *after* all other hooks execute

FormIt 1.5.0
====================================
- Fixed bug with redirectParams not parsing placeholders in the params
- Added redirectParams property, which allows a JSON object of params to be passed when using redirect hook
- Added spamCheckIp property, defaults to false, to check IP as well in spam hook
- Fixed incorrect default param for fiarSender
- Fixed error reporting for FormItAutoResponder
- Added sanity checks to form attachments when dealing with missing names
- Fixed invalid offset error in checkbox validation
- Added recaptchaJS to allow for custom JS overriding of reCaptcha options var

FormIt 1.4.1
====================================
- Added sanity check for emailHtml property on email hook
- Added sanity check for replyto/cc/bcc emails on email hook
- Added ability to change language via &language parameter

FormIt 1.4.0
====================================
- Fixed bug with recaptcha and other hooks error display messages
- Introduced &validate parameter for more secure validation parameters to prevent POST injection
- Added FormItIsChecked and FormItIsSelected custom output filters for easier checkbox/radio/select handling of selected values
- Added &placeholderPrefix for FormIt snippet, defaults to `fi.`

FormIt 1.3.0
====================================
- Fixed issue with isNumber validator
- Added FormItRetriever snippet to get data from a FormIt submission for thank you pages
- Added extra API methods for custom hooks for easier data grabbing
- Added FormItAutoResponder snippet to use as a custom hook for auto-responses
- Added &successMessage and &successMessagePlaceholder properties for easier success message handling
- Fixed ordering for &emailFrom property
- Added width/height for reCaptcha, however, reCaptcha APIs prevent resizing via calls

FormIt 1.2.1
====================================
- Added recaptchaTheme property, which allows theming of reCaptcha hook

FormIt 1.2.0
====================================
- Added preHooks property to allow for custom snippets to pre-fill fields
- Added clearFieldsOnSuccess property to clear fields after a successful form submission without a redirect
- Allow placeholders of fields in all email properties
- Added customValidators property to FormIt snippet to restrict custom validators to only specified validators to prevent brute force snippet loading
- Added fiValidator::addError for easier error loading for custom validators
- Added German translation

FormIt 1.1.7
====================================
- Added bcc and cc properties for email hook

FormIt 1.1.6
====================================
- i18n of Snippet properties
- Added emailReplyToName and emailReplyTo properties for email hook
- Removed SMTP settings as those are now in Revo
- Fixed bug in html emails where linebreaks were being ignored
- Added islowercase and isuppercase validators
- Added multibyte support to validators

FormIt 1.1.5
====================================
- Added Russian translation
- Updated copyright information

FormIt 1.1.4
====================================
- Fixed bug with isDate check
- Migrated FormIt to Git
- Fixed bug that caused validators to not fire
- Fixed bug where custom validators were wonky, added \'errors\' references to custom hooks/validators
- [#ADDON-147] Added support for validation and emailing of file fields
- Added stripTags to all fields by default (unless \'allowTags\' hook is passed\') to prevent XSS
- Added in missing settings
- Added reCaptcha support via the recaptcha hook
- Adjusted copyright information to reflect current year

FormIt 1.0
====================================
- Fixed bug with emailFrom property getting overwritten
- [#ADDON-122] Fixed incorrect message in spam lexicon item
- Added \'spam\' hook that utilizes StopForumSpam spam filter. Will filter the fields in the property &spamEmailFields
- Ensure hooks errors are set as placeholders
- Aded fi.success placeholder to be set on a successful form submission if no redirect hook is specified
- Added default to emailTpl property so that it is now no longer required. Will send out email with just field names and values.
- Added Dutch translation
- Added missing formit.contains lexicon entry
- Fixed possible loophole with $this->fields and referencing in multiple hooks
- Fixed bug on hooks due to !== and != difference
- Added SMTP support to FormIt email hook
- Fixed bug with emailFrom in email hook
- Added emailUseFieldForSubject property to FormIt snippet
- Fixed bug on email hook where if subject was passed through form, it wouldn\'t set it as email subject
- Added changelog
',
    'setup-options' => 'formit-4.2.5-pl/setup-options.php',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => '64802f6ff7b83dba58eb9e0de9fd96e8',
      'native_key' => 'formit',
      'filename' => 'modNamespace/268841f6a00d2e923fba45118852b236.vehicle',
      'namespace' => 'formit',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '30c3fff20b1f4770a895a8ba096dde61',
      'native_key' => 'formit.recaptcha_public_key',
      'filename' => 'modSystemSetting/54783dac0c7e5cf57925db2b64f6f632.vehicle',
      'namespace' => 'formit',
    ),
    2 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'ef53ab82b30f17d0811fabc6e8d0b1a5',
      'native_key' => 'formit.recaptcha_private_key',
      'filename' => 'modSystemSetting/65f0ba746a143b28ca0e21979af1d4b3.vehicle',
      'namespace' => 'formit',
    ),
    3 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '4831ddd0f8b521163bcbe98e9f315116',
      'native_key' => 'formit.recaptcha_use_ssl',
      'filename' => 'modSystemSetting/d544416c607676559c4f5d0462bb4a84.vehicle',
      'namespace' => 'formit',
    ),
    4 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'cac507ec64c6e51acc67a7c7b0b14e3e',
      'native_key' => 'formit.exclude_contexts',
      'filename' => 'modSystemSetting/f5f1f096ab4d12c01117ea18197bb5d0.vehicle',
      'namespace' => 'formit',
    ),
    5 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '4edee42c34352eb99d61cdd3ed45a783',
      'native_key' => 'formit.form_encryptkey',
      'filename' => 'modSystemSetting/107441c9f3ec042410105b7ed498b4a1.vehicle',
      'namespace' => 'formit',
    ),
    6 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'f5326e43d7a27bb0102e88f11bcf2c9c',
      'native_key' => 'formit.attachment.mediasource',
      'filename' => 'modSystemSetting/c86a4d90b15231a07c5e40c7ba757a2f.vehicle',
      'namespace' => 'formit',
    ),
    7 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '5119bd9df289b8747ebdaf18bda7e942',
      'native_key' => 'formit.attachment.path',
      'filename' => 'modSystemSetting/07920208218f5dbc898e4f91dc059cf4.vehicle',
      'namespace' => 'formit',
    ),
    8 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '34103413edcebb325325f4a63ea4af23',
      'native_key' => 'formit.cleanform.days',
      'filename' => 'modSystemSetting/84016d187d1ea746e490580230462964.vehicle',
      'namespace' => 'formit',
    ),
    9 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '38fc7bd42f5561d4ecd88790b7434434',
      'native_key' => 'formit.max_chars_textfield',
      'filename' => 'modSystemSetting/6992bbb7a6feb9e2618892e4bfa9fdf9.vehicle',
      'namespace' => 'formit',
    ),
    10 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modCategory',
      'guid' => '557592b948be5bcf1261e7fee5c32976',
      'native_key' => NULL,
      'filename' => 'modCategory/521b5c7d0f50c8ae19b92ee942efe8ec.vehicle',
      'namespace' => 'formit',
    ),
    11 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modMenu',
      'guid' => 'bb71c132776edd6ba891fda706816ea7',
      'native_key' => 'formit',
      'filename' => 'modMenu/f03d02e543a60bbef7eb67b38979cf2c.vehicle',
      'namespace' => 'formit',
    ),
  ),
);